<?php

namespace Mtc\MercuryDataModels\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\DrivetrainType;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleModel;

class VehicleFactory extends Factory
{
    protected $model = Vehicle::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $vehicle_model = VehicleModel::factory()->createOne();
        return [
            'uuid' => Str::uuid(),
            'published_at' => Carbon::now()->subDays(random_int(1, 100)),
            'slug' => implode('-', $this->faker->words(3)),
            'vin' => Str::upper(Str::random(17)),
            'title' => $this->faker->name(),
            'derivative' => $this->faker->jobTitle(),
            'registration_number' => Str::random(2) . random_int(10, 99) . ' ' . Str::random(3),
            'featured' => $this->faker->boolean(),
            'is_published' => $this->faker->boolean(),
            'is_sold' => $this->faker->boolean(),
            'is_demo' => $this->faker->boolean(),
            'is_reserved' => $this->faker->boolean(),
            'make_id' => $vehicle_model->make_id,
            'model_id' => $vehicle_model,
            'transmission_id' => TransmissionType::factory()->createOne(),
            'fuel_type_id' => FuelType::factory()->createOne(),
            'drivetrain_id' => DrivetrainType::factory()->createOne(),
            'colour' => $this->faker->colorName(),
            'price' => random_int(3000, 150000),
            'door_count' => random_int(3, 5),
            'seats' => random_int(3, 5),
            'manufacture_year' => random_int(2000, 2022),
            'odometer_km' => random_int(0, 200000),
            'odometer_mi' => random_int(0, 100000),
            'engine_size_cc' => random_int(800, 3500),
            'previous_owner_count' => random_int(0, 5),
            'first_registration_date' => $this->faker->dateTimeBetween('-20 years')->format('Y-m-d'),
            'description' => $this->faker->paragraph(),
            'data' => [],
            'exterior_video_url' => $this->faker->url(),
            'interior_video_url' => $this->faker->url(),
            'cap_id' => random_int(10000, 90000),
            'main_video_url' => $this->faker->url(),
            'mpg' => (random_int(2000, 21000) / 100),
            'co2' => (random_int(2000, 21000) / 100),
            'type' => $this->faker->name(),
            'battery_capacity_kwh' => random_int(100, 300),
            'battery_quick_charge_time' => random_int(10, 30),
            'battery_range' => random_int(100, 300),
        ];
    }
}
