<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\VehicleFinance;

class VehicleFinanceFactory extends Factory
{
    protected $model = VehicleFinance::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'vehicle_id' => random_int(1, 100),
            'provider' => $this->faker->word(),
            'finance_type' => random_int(0, 1) ? 'HP' : 'PCP',
            'term' => random_int(12, 72),
            'number_of_payments' => random_int(12, 72),
            'monthly_price' => random_int(10, 1500),
            'first_payment' => random_int(10, 1500),
            'final_payment' => random_int(10, 1500),
            'deposit' => random_int(100, 30000),
            'apr' => random_int(1, 500) / 10,
            'interest_rate' => random_int(1, 250) / 10,
            'apply_url' => $this->faker->url(),
        ];
    }
}
