<?php

namespace Mtc\MercuryDataModels\Filters;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\Vehicle;

class EngineSizeMaxFilter extends EngineSizeMinFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->where('engine_size_cc', '<', $selection);
    }

    public function title(): string
    {
        return 'Maximum Engine Size';
    }
}
