<?php

namespace Mtc\MercuryDataModels\Filters;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Vehicle;

class ManufactureYearMaxFilter extends ManufactureYearMinFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->where('manufacture_year', '<', $selection);
    }

    public function title(): string
    {
        return 'Maximum Manufacture Year';
    }
}
