<?php

namespace Mtc\MercuryDataModels\Filters;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Vehicle;

class ManufactureYearMinFilter extends IsFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->where('manufacture_year', '>=', $selection);
    }

    /**
     * Get available results of this filter type
     *
     * @param \Closure $product_filtering
     * @param int $limit
     * @param array $selections
     * @return Collection
     */
    public function getResults(\Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        return Vehicle::query()
            ->where($product_filtering)
            ->distinct()
            ->orderByDesc('manufacture_year')
            ->pluck('manufacture_year')
            ->map(fn ($year) => [
                'id' => $year,
                'name' => $year,
            ]);
    }

    /**
     * Format result for front-end
     *
     * @param Collection $collection
     * @return array
     */
    public function format(Collection $collection): array
    {
        return [
            'title' => $this->title(),
            'ui_component' => $this->uiComponentType(),
            'has_load_more' => $this->hasLoadMore($collection),
            'results' => $collection,
            'show' => $this->visibleByDefault(),
            'min_count_to_show' => $this->minCountToShow(),
        ];
    }

    public function getModel(): string
    {
        return '';
    }

    public function title(): string
    {
        return 'Minimum Manufacture Year';
    }

    public function modelSlug(Model $model): string
    {
        return '';
    }
}
