<?php

namespace Mtc\MercuryDataModels\Filters;

use App\Facades\Settings;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\Vehicle;

class MileageMaxFilter extends MileageMinFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $mileage_column = $this->mileageColumn();
        $query->where($mileage_column, '<', $selection);
    }

    public function title(): string
    {
        return 'Maximum Mileage';
    }
}
