<?php

namespace Mtc\MercuryDataModels\Filters;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\Vehicle;

class PriceMaxFilter extends PriceMinFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->where('price', '<', $selection);
    }

    public function title(): string
    {
        return 'Maximum Price';
    }
}
