<?php

namespace Mtc\MercuryDataModels\Filters;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\Vehicle;

class PriceMinFilter extends IsFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->where('price', '>=', $selection);
    }

    public function getResults(Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        $min = floor(Vehicle::query()->where($product_filtering)->min('price'));
        $max = ceil(Vehicle::query()->where($product_filtering)->max('price'));

        $ranges = collect(Config::get('automotive.filter-ranges.price'));
        return $ranges
            // Up to max range including one step over current max
            ->filter(fn($range, $i) => $range < $max || ($i > 0 && $range > $max && $ranges[$i - 1] < $max))
            ->filter(fn($range, $i) => $range > $min
                || ($i < $ranges->count() - 1 && $range < $min && $ranges[$i + 1] > $min))
            ->map(fn($range, $i) => [
                'id' => $range,
                'value' => $range,
                'name' => number_format($range),
            ])
            ->values();
    }

    /**
     * Format result for front-end
     *
     * @param Collection $collection
     * @return array
     */
    public function format(Collection $collection): array
    {
        return [
            'title' => $this->title(),
            'ui_component' => $this->uiComponentType(),
            'has_load_more' => $this->hasLoadMore($collection),
            'results' => $collection,
            'show' => $this->visibleByDefault(),
            'min_count_to_show' => $this->minCountToShow(),
        ];
    }

    public function getModel(): string
    {
        return '';
    }

    public function title(): string
    {
        return 'Minimum Price';
    }

    public function modelSlug(Model $model): string
    {
        return '';
    }
}
