<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;
use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\MercuryDataModels\Factories\PropertyFactory;
use Mtc\MercuryDataModels\Factories\TransmissionTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use Mtc\MercuryDataModels\Traits\OrderByName;

class Property extends Model
{
    use HasFactory;
    use OrderByName;
    use ModelSortAndFilter;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'properties';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'slug',
        'active',
        'category_id',
        'data',
    ];

    protected $casts = [
        'active' => 'boolean',
        'data' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();
        self::creating(static fn(self $property) => $property->ensureSlug());
        self::deleted(static fn(self $property) => $property->attributeValues()->delete());
    }

    protected static function newFactory()
    {
        return PropertyFactory::new();
    }

    public function category(): BelongsTo
    {
        return  $this->belongsTo(PropertyCategory::class, 'category_id');
    }

    public function attributeValues(): HasMany
    {
        return $this->hasMany(PropertyAttributeValue::class, 'property_id');
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('active', 1);
    }

}
