<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Str;
use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\MercuryDataModels\Factories\PropertyFactory;
use Mtc\MercuryDataModels\Factories\TransmissionTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use Mtc\MercuryDataModels\Traits\OrderByName;

class PropertyAttributeValue extends Model
{
    use HasFactory;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'property_attribute_values';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'property_id',
        'field_id',
        'slug',
        'type',
        'value',
        'value_float',
        'value_datetime',
        'value_text',
        'order',
        'index',
    ];

    protected $casts = [
        'active' => 'boolean',
        'data' => 'array',
    ];

    public function property(): BelongsTo
    {
        return $this->belongsTo(Property::class, 'property_id');
    }

    public function propertyField(): BelongsTo
    {
        return $this->belongsTo(PropertyCategoryField::class, 'field_id');
    }

    public function getValue()
    {
        return match($this->type) {
            'text' => $this->attributes['value_text'],
            'number' => $this->attributes['value_float'],
            'datetime' => $this->attributes['value_datetime'],
            default => $this->attributes['value'],
        };
    }

}
