<?php

namespace Mtc\MercuryDataModels\Repositories;

use App\Contracts\FeatureFlag;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Tenant;
use Mtc\MercuryDataModels\TenantFeature;

class FeatureRepository
{
    public function isEnabled(string $feature): bool
    {
        return TenantFeature::query()
            ->where('feature', $feature)
            ->where('tenant_id', tenant('id'))
            ->exists();
    }

    public function getAll(): Collection
    {
        return collect(config('features.all', []))
            ->filter(fn(string $class) => class_exists($class))
            ->map(fn ($class, $feature) => App::make($class))
            ->filter(fn($class) => $class instanceof FeatureFlag);
    }

    public function enabledForTenant(): Collection
    {
        $enabled = TenantFeature::query()
            ->where('tenant_id', tenant('id'))
            ->pluck('feature');
        return collect(config('features.all', []))
            ->filter(fn($class, $feature) => class_exists($class) && $enabled->search($feature) !== false)
            ->map(fn ($class, $feature) => App::make($class))
            ->filter(fn($class) => $class instanceof FeatureFlag);
    }

    public function setEnabled(Tenant $tenant, array $features): void
    {
        $tenant->features()
            ->whereNotIn('feature', $features)
            ->delete();

        collect($features)
            ->each(fn($feature) => $tenant->features()->updateOrCreate(['feature' => $feature]));
    }
}
