<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Log;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\SeoDataFactory;

class SeoData extends Model
{
    use HasFactory;
    use HasMedia;

    public const TITLE_MIN_LENGTH = 43;
    public const DESCRIPTION_MIN_LENGTH = 100;

    protected $table = 'seo_data';

    /**
     * Mass assign
     *
     * @var string[]
     */
    protected $fillable = [
        'path',
        'title',
        'description',
        'heading',
        'content_element_id',
        'content',
    ];

    protected $casts = [
        'content' => 'array',
    ];

    /**
     * Hide from JSON
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * New model factory
     *
     * @return SeoDataFactory
     */
    protected static function newFactory()
    {
        return SeoDataFactory::new();
    }

    public function contentElement(): BelongsTo
    {
        return $this->belongsTo(ContentElement::class, 'content_element_id');
    }

    /**
     * Make sure media file values are synced
     * @return void
     */
    public function attachContentMedia()
    {
        $mediaFiles = collect();
        collect($this->content ?? [])
            ->each(function ($content) use ($mediaFiles) {
                if (($content['field_type'] ?? '') === 'image') {
                    $mediaFiles->push($content['content'] ?? []);
                }
            });

        Log::debug('attach media to object', [
            $mediaFiles,
            $this->content,
        ]);
        Media::setUsesForModel($mediaFiles->flatten()->unique()->toArray(), $this);
    }
}
