<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_location_availability', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dealership_id')->index();
            $table->boolean('active')->nullable()->index();
            $table->unsignedSmallInteger('number_of_bays');
            $table->text('time_windows')->nullable();
            $table->boolean('mondays')->nullable();
            $table->boolean('tuesdays')->nullable();
            $table->boolean('wednesdays')->nullable();
            $table->boolean('thursdays')->nullable();
            $table->boolean('fridays')->nullable();
            $table->boolean('saturdays')->nullable();
            $table->boolean('sundays')->nullable();
            $table->timestamps();
        });

        Schema::create('service_location_availability_holidays', function (Blueprint $table) {
            $table->id();
            $table->foreignId('availability_id')->index();
            $table->date('holiday_date')->index();
            $table->string('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_location_availability');
        Schema::dropIfExists('service_location_availability_holidays');
    }
};
