<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('valuations', function (Blueprint $table) {
            $table->renameColumn('adjusted_value', 'adjusted_retail_price');
            $table->decimal('adjusted_average_price')->nullable();
            $table->decimal('adjusted_clean_price')->nullable();
            $table->decimal('adjusted_below_price')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('valuations', function (Blueprint $table) {
            $table->renameColumn('adjusted_retail_price', 'adjusted_value');
            $table->dropColumn([
                'adjusted_average_price',
                'adjusted_clean_price',
                'adjusted_below_price',
            ]);
        });
    }
};
