<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->integer('battery_quick_charge_start_level')->nullable();
            $table->string('battery_slow_charge_description')->nullable();
            $table->string('battery_quick_charge_description')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn([
                'battery_quick_charge_start_level',
                'battery_slow_charge_description',
                'battery_quick_charge_description',
            ]);
        });
    }
};
