<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CarConfiguratorEditionFactory;

class CarConfiguratorEdition extends Model
{
    use HasFactory;
    use HasMedia;
    use SoftDeletes;

    protected $table = 'car_configurator_editions';

    protected $fillable = [
        'model_id',
        'name',
        'short_description',
        'price',
        'data',
        'order',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected static function newFactory()
    {
        return CarConfiguratorEditionFactory::new();
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(CarConfiguratorModel::class, 'model_id');
    }

    public function restrictions(): MorphMany
    {
        return $this->morphMany(CarConfiguratorRestriction::class, 'functionality');
    }
}
