<?php

namespace Mtc\MercuryDataModels\Finance\Contracts;

use Mtc\MercuryDataModels\Vehicle;

interface FinanceProvider
{
    public function calculate(FinanceRequestData $data): FinanceResultCollection;

    public function dealerIdDataField(): string;

    public function dealerSpecificAccountKey(): ?string;

    public function isEligibleForCreditRatingFinance(Vehicle $vehicle): bool;

    public function calculateRiskBased(FinanceRequestData $data): FinanceResultCollection;
}
