<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\ContentManager\Traits\ModelSortAndFilter;
use OwenIt\Auditing\Contracts\Auditable;

class Shortcode extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use ModelSortAndFilter;

    protected $fillable = [
        'name',
        'code',
        'model',
    ];

    public function conditions(): HasMany
    {
        return $this->hasMany(ShortcodeCondition::class, 'shortcode_id');
    }
}
