<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Mtc\MercuryDataModels\Factories\ReplacementFactory;

/**
 * @property int $id
 * @property string $original
 * @property string $replacement
 * @property string $type
 */
class Replacement extends Model
{
    use HasFactory;

    public static array $types = [
        'global' => 'Global',
        Vehicle::class => 'Vehicle',
        VehicleOffer::class => 'Vehicle Offer',
    ];

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'original',
        'replacement',
        'type',
    ];

    protected static function newFactory()
    {
        return ReplacementFactory::new();
    }

    public function getTypeLabelAttribute()
    {
        return self::$types[$this->type];
    }

    public function resetCache(): void
    {
        foreach (self::$types as $type => $label) {
            Cache::forget(tenant('id') . '-replacements-' . $type);
        }
    }
}
