<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\InvoiceAddressFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class InvoiceAddress extends Model
{
    use HasFactory;
    use CentralConnection;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_addresses';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'invoice_id',
        'type',
        'title',
        'first_name',
        'last_name',
        'address1',
        'address2',
        'city',
        'county',
        'postcode',
        'country',
        'state',
    ];

    /**
     * Model Factory
     *
     * @return InvoiceAddressFactory
     */
    protected static function newFactory()
    {
        return InvoiceAddressFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }
}
