<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('fuel_types', 'ev_data') === false) {
            Schema::table('fuel_types', function (Blueprint $table) {
                $table->boolean('ev_data')->nullable();
                $table->boolean('mpg_data')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('fuel_types', function (Blueprint $table) {
            $table->dropColumn([
                'ev_data',
                'mpg_data',
            ]);
        });
    }
};
