<?php

namespace Mtc\MercuryDataModels;

use App\ImportConditionRepository;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use OwenIt\Auditing\Contracts\Auditable;

class CatalogOfferRule extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;

    protected $fillable = [
        'catalog_offer_id',
        'field',
        'condition',
        'value',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected $appends = [
        'field_name',
        'condition_name',
        'value_name',
    ];

    public function catalogOffer(): BelongsTo
    {
        return $this->belongsTo(CatalogOffer::class);
    }

    public function getFieldNameAttribute(): string
    {
        return __('vehicles.' . $this->field);
    }

    public function getConditionNameAttribute(): string
    {
        return __('labels.conditions.' . $this->condition);
    }

    public function getValueNameAttribute()
    {
        return (new ImportConditionRepository())->getValue($this->field, $this->value);
    }
}
