<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Contracts\Auditable;

class ReservationPrice extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'reservation_prices';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'label',
        'price',
        'active',
        'data'
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'active' => 'bool',
        'data' => 'array',
    ];

    public function rules(): HasMany
    {
        return $this->hasMany(ReservationPriceRule::class);
    }
}
