<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('seo_data', function (Blueprint $table) {
            $table->foreignId('content_element_id')->index()->nullable();
            $table->mediumText('content')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('seo_data', function (Blueprint $table) {
            $table->dropColumn([
                'content_element_id',
                'content',
            ]);
        });
    }
};
