<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\FilterFeature;

class FilterFeatureFactory extends Factory
{
    protected $model = FilterFeature::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $name = $this->faker->word();
        return [
            'name' => $name,
            'slug' => Str::slug($name),
            'check_in_options' => random_int(0, 1),
            'check_in_tech_data' => random_int(0, 1),
            'terms' => ['foo', 'baz'],
        ];
    }
}
