<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Factories\OfferTypeFactory;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use OwenIt\Auditing\Contracts\Auditable;

class OfferType extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;
    use EnsuresSlug;

    protected $table = 'offer_types';

    protected $fillable = [
        'name',
        'slug',
        'template_id',
        'parent_id',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected static function newFactory()
    {
        return OfferTypeFactory::new();
    }

    protected static function boot()
    {
        parent::boot();
        self::saving(fn(self $model) => $model->ensureSlug());
    }

    /**
     * Relationship with template that defines content structure
     *
     * @return BelongsTo
     */
    public function template(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.template_model'));
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(self::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(self::class, 'parent_id');
    }
}
