<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->renameColumn('deposit', 'total_deposit');
        });

        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->integer('annual_mileage')->nullable();
            $table->decimal('cash_price', 8, 2)->nullable();
            $table->decimal('dealer_deposit', 8, 2)->nullable()->after('final_payment');
            $table->decimal('customer_deposit', 8, 2)->nullable()->after('final_payment');
            $table->decimal('payable_amount', 8, 2)->nullable()->after('total_credit_amount');
            $table->decimal('option_to_purchase_fee', 8, 2)->nullable();
            $table->decimal('documentation_fee', 8, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->renameColumn('total_deposit', 'deposit');
        });

        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->dropColumn('annual_mileage');
            $table->dropColumn('cash_price');
            $table->dropColumn('dealer_deposit');
            $table->dropColumn('customer_deposit');
            $table->dropColumn('payable_amount');
            $table->dropColumn('option_to_purchase_fee');
            $table->dropColumn('documentation_fee');
        });
    }
};
