<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\TenantBillingDetailFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class TenantBillingDetail extends Model
{
    use HasFactory;
    use CentralConnection;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'tenant_billing_details';

    /**
     * Mass assign attributes
     *
     * @var array
     */
    protected $fillable = [
        'tenant_id',
        'vat_rate',
        'billing_email',
        'contact_no',
        'title',
        'first_name',
        'last_name',
        'address1',
        'address2',
        'city',
        'county',
        'postcode',
        'country',
        'state',
    ];

    /**
     * Model Factory
     *
     * @return TenantBillingDetailFactory
     */
    protected static function newFactory()
    {
        return TenantBillingDetailFactory::new();
    }

    /**
     * Relationship with tenant
     *
     * @return BelongsTo
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }
}
