<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->index(['deleted_at'], 'pages_deleted_at_idx');
        });
        Schema::table('page_versions', function (Blueprint $table) {
            $table->index(['deleted_at'], 'page_versions_deleted_at_idx');
        });
        Schema::table('vehicles', function (Blueprint $table) {
            $table->index(['deleted_at'], 'vehicles_deleted_at_idx');
        });
        Schema::table('new_cars', function (Blueprint $table) {
            $table->index(['deleted_at'], 'new_cars_deleted_at_idx');
        });
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->index(['deleted_at'], 'vehicle_offers_deleted_at_idx');
        });
        Schema::table('forms', function (Blueprint $table) {
            $table->index(['deleted_at'], 'forms_deleted_at_idx');
        });
        Schema::table('enquiries', function (Blueprint $table) {
            $table->index(['deleted_at'], 'enquiries_deleted_at_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropIndex('pages_deleted_at_idx');
        });
        Schema::table('page_versions', function (Blueprint $table) {
            $table->dropIndex('page_versions_deleted_at_idx');
        });
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropIndex('vehicles_deleted_at_idx');
        });
        Schema::table('new_cars', function (Blueprint $table) {
            $table->dropIndex('new_cars_deleted_at_idx');
        });
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropIndex('vehicle_offers_deleted_at_idx');
        });
        Schema::table('forms', function (Blueprint $table) {
            $table->dropIndex('forms_deleted_at_idx');
        });
        Schema::table('enquiries', function (Blueprint $table) {
            $table->dropIndex('enquiries_deleted_at_idx');
        });
    }
};
