<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('global_content', function (Blueprint $table) {
            $table->dateTime('available_from')->nullable()->after('element_id');
            $table->dateTime('available_to')->nullable()->after('available_from');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('global_content', function (Blueprint $table) {
            $table->dropColumn('available_from');
            $table->dropColumn('available_to');
        });
    }
};
