<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_trims', function (Blueprint $table) {
            $table->boolean('active')->default(1)->index();
            $table->unsignedBigInteger('model_id')->index()->nullable();
            $table->text('fuel_types')->nullable();
            $table->text('colours')->nullable();
            $table->text('transmission_types')->nullable();
            $table->decimal('mpg', 8, 2)->nullable();
            $table->decimal('emissions', 8, 2)->nullable();
            $table->decimal('engine_size', 8, 2)->nullable();
            $table->decimal('bhp', 8, 2)->nullable();
            $table->decimal('zero_to_sixty', 8, 2)->nullable();
            $table->integer('doors')->nullable()->index();
            $table->integer('seats')->nullable()->index();
            $table->decimal('battery_size', 8, 2)->nullable();
            $table->decimal('range_miles', 8, 2)->nullable();
            $table->integer('battery_charge_time')->nullable()->index();
            $table->integer('battery_quick_charge_time')->nullable()->index();
            $table->string('wheelbase')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_trims', function (Blueprint $table) {
            $table->dropColumn('active');
            $table->dropColumn('model_id');
            $table->dropColumn('fuel_types');
            $table->dropColumn('colours');
            $table->dropColumn('transmission_types');
            $table->dropColumn('mpg');
            $table->dropColumn('emissions');
            $table->dropColumn('engine_size');
            $table->dropColumn('bhp');
            $table->dropColumn('zero_to_sixty');
            $table->dropColumn('doors');
            $table->dropColumn('seats');
            $table->dropColumn('battery_size');
            $table->dropColumn('range_miles');
            $table->dropColumn('battery_charge_time');
            $table->dropColumn('battery_quick_charge_time');
            $table->dropColumn('wheelbase');
        });
    }
};
