<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reservation_prices', function (Blueprint $table) {
            $table->id();
            $table->string('label')->nullable();
            $table->decimal('price')->index()->nullable();
            $table->boolean('active')->index()->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::create('reservation_price_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('reservation_price_id')->index();
            $table->string('field');
            $table->string('condition', 30)->nullable();
            $table->string('value');
            $table->text('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reservation_prices');
        Schema::dropIfExists('reservation_price_rules');
    }
};
