<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\ServiceProvider;
use Mtc\MercuryDataModels\Contracts\LocatingServiceEngine;
use Mtc\MercuryDataModels\Services\Location\PafLocationService;

class DataProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/automotive.php', 'automotive');
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/features.php', 'features');
    }

    public function boot()
    {
        $this->app->bind(LocatingServiceEngine::class, PafLocationService::class);

        Relation::morphMap([
            'user' => \config('auth.providers.users.model'),
            'dealership' => Dealership::class,
            'franchise' => Franchise::class,
            'enquiry' => Enquiry::class,
            'booking' => Booking::class,
            'car-configuration' => CustomerCarConfiguration::class,
            'car-config-model' => CarConfiguratorModel::class,
            'car-config-interior' => CarConfiguratorInterior::class,
            'car-config-trim' => CarConfiguratorTrim::class,
            'car-config-edition' => CarConfiguratorEdition::class,
            'car-config-wheel' => CarConfiguratorWheel::class,
            'car-config-engine' => CarConfiguratorEngine::class,
            'car-config-colour' => CarConfiguratorColour::class,
            'vehicle' => Vehicle::class,
            'offer' => VehicleOffer::class,
            'offer-content' => VehicleOfferContent::class,
            'offer-version' => VehicleOfferContentHistory::class,
            'dealership-content' => DealershipContent::class,
            'dealership-version' => VehicleOfferContentHistory::class,
            'dealership-department' => DealershipDepartment::class,
            'new-car' => NewCar::class,
            'new-car-content' => NewCarContent::class,
            'new-car-version' => NewCarContentHistory::class,
            'make' => VehicleMake::class,
            'model' => VehicleModel::class,
            'fuel_type' => FuelType::class,
            'transmission' => TransmissionType::class,
            'body_type' => BodyStyleType::class,
            'drivetrain' => DrivetrainType::class,
            'seo-default' => SeoDefault::class,
            'seo-data' => SeoData::class,
            'setting' => Setting::class,
            'property-attribute' => PropertyAttributeValue::class,
            'property' => Property::class,
            'vehicle-trim' => VehicleTrim::class,
            'valuation' => VehicleValuation::class,
            'lease-vehicle' => KeyloopLeaseVehicleVariant::class,
            'form' => Form::class,
            'form-section' => FormSection::class,
            'form-question' => FormQuestion::class,
            'vehicle-feature' => VehicleFeature::class,
            'vehicle-attribute-value' => VehicleAttributeValue::class,
            'offer-type' => OfferType::class,
        ]);
    }
}
