<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\ContentManager\PageStatus;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\VehicleOffer;

class NewCarFactory extends Factory
{
    protected $model = NewCar::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'status' => collect(array_map(fn (PageStatus $status) => $status->value, PageStatus::cases()))->random(),
            'name' => $this->faker->sentence(),
            'derivative' => $this->faker->sentence(),
            'featured' => $this->faker->boolean(),
            'make_id' => random_int(1, 10),
            'model_id' => random_int(1, 25),
            'form_id' => random_int(1, 10),
            'template_id' => random_int(1, 10),
            'price' => random_int(50, 2500),
            'deposit' => random_int(3, 90) * 100,
            'seo' => [],
            'data' => [],
        ];
    }
}
