<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Factories\VehicleReviewFactory;

class VehicleReview extends Model
{
    use HasFactory;

    protected $table = 'vehicle_reviews';

    protected $fillable = [
        'provider',
        'external_review_id',
        'review',
        'meta',
    ];

    protected $casts = [
        'review' => 'array',
        'meta' => 'array',
    ];

    /**
     * Relationship with Vehicle
     *
     * @return BelongsTo
     */
    public function vehicles()
    {
        return $this->belongsToMany(
            Vehicle::class,
            'vehicle_review_uses',
            'vehicle_review_id',
            'vehicle_id'
        );
    }

    protected static function newFactory()
    {
        return VehicleReviewFactory::new();
    }
}
