<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServicePackage extends Model
{
    use HasFactory;

    protected $table = 'service_packages';

    protected $fillable = [
        'applicable_make_id',
        'applicable_model_id',
        'type',
        'name',
        'price',
        'description',
    ];

    protected static function boot()
    {
        parent::boot();
        self::creating(fn(self $package) => $package->ensureType());
    }

    private function ensureType()
    {
        if (empty($this->attributes['type'])) {
            $this->attributes['type'] = 'package';
        }
    }
}
