<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ev_data', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ev_db_id')->index();
            $table->string('vehicle_type')->nullable()->index();
            $table->foreignId('make_id')->nullable()->index();
            $table->foreignId('model_id')->nullable()->index();
            $table->string('variant')->nullable();
            $table->date('date_from')->nullable()->index();
            $table->date('date_to')->nullable()->index();
            $table->text('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ev_data');
    }
};
