<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_alert_subscribers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id');
            $table->foreignId('system_alert_id');
            $table->unique(['user_id', 'system_alert_id']);
            $table->timestamps();
        });

        Schema::table('system_alerts', function (Blueprint $table) {
            $table->integer('time_condition')->nullable();
            $table->string('value_condition')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_alert_subscribers');

        Schema::table('system_alerts', function (Blueprint $table) {
            $table->dropColumn(['time_condition', 'value_condition']);
        });
    }
};
