<?php

namespace Mtc\MercuryDataModels\Finance\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\Finance\Contracts\ExportsStockToFinance;

class RunFinanceExport implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(
        private readonly ExportsStockToFinance $provider,
    ) {
        $this->onQueue('finance');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->provider->export();
    }
}
