<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFormsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('forms', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('type_id')->nullable()->index();
            $table->boolean('is_active')->nullable()->index();
            $table->dateTime('active_from')->nullable()->index();
            $table->dateTime('active_until')->nullable()->index();
            $table->text('actions')->nullable();
            $table->text('data')->nullable();
            $table->boolean('notify_customer_on_received_enquiry')->default(0);
            $table->string('customer_notification_subject')->nullable();
            $table->text('customer_notification_content')->nullable();
            $table->text('success_message')->nullable();
            $table->foreignId('initial_status_id')->nullable()->index();
            $table->foreignId('initial_assignee')->nullable()->index();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('form_actions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('form_id')->index();
            $table->string('action_name')->index();
            $table->text('fields')->nullable();
            $table->timestamps();
        });

        Schema::create('form_sections', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('form_id')->index();
            $table->string('name')->nullable();
            $table->boolean('is_active')->default(1)->index();
            $table->text('settings')->nullable();
            $table->unsignedInteger('order')->default(0);
            $table->timestamps();
        });

        Schema::create('form_questions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('form_id')->index();
            $table->unsignedBigInteger('form_section_id')->index();
            $table->string('name')->nullable();
            $table->string('type')->index();
            $table->boolean('is_active')->default(1)->index();
            $table->boolean('is_customers_email')->default(0)->index();
            $table->boolean('is_enquiry_subject')->default(0)->index();
            $table->text('description')->nullable();
            $table->string('placeholder')->nullable();
            $table->text('answer_options')->nullable();
            $table->string('validation', 500)->nullable();
            $table->text('data')->nullable();
            $table->text('settings')->nullable();
            $table->unsignedInteger('order')->default(0);
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('forms');
        Schema::dropIfExists('form_sections');
        Schema::dropIfExists('form_questions');
    }
}
