<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_makes', function (Blueprint $table) {
            $table->string('keyloop_id')->nullable()->index();
            $table->boolean('keyloop_import_enabled')->default(false)->index();
        });

        Schema::table('vehicle_models', function (Blueprint $table) {
            $table->string('keyloop_id')->nullable()->index();
            $table->boolean('keyloop_import_enabled')->default(false)->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_makes', function (Blueprint $table) {
            $table->dropColumn([
                'keyloop_id',
                'keyloop_import_enabled',
            ]);
        });

        Schema::table('vehicle_models', function (Blueprint $table) {
            $table->dropColumn([
                'keyloop_id',
                'keyloop_import_enabled',
            ]);
        });
    }
};
