<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\CarConfiguratorExtra;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\ColourMap>
 */
class CarConfiguratorExtraFactory extends Factory
{
    protected $model = CarConfiguratorExtra::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->word(),
            'description' => $this->faker->sentence(),
            'category' => $this->faker->word(),
            'price' => $this->faker->numberBetween(10, 1000),
        ];
    }
}
