<?php

namespace Mtc\MercuryDataModels\Filters;

use App\Facades\Settings;
use Closure;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferPriceMinFilter extends PriceMinFilter
{
    protected function getData(Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        if (empty(self::$data)) {
            $min = floor(VehicleOffer::query()
                ->when(
                    Settings::get('filter-apply-selections-to-results'),
                    fn($query) => $query->where($product_filtering)
                )
                ->min('price'));
            $max = ceil(VehicleOffer::query()
                ->when(
                    Settings::get('filter-apply-selections-to-results'),
                    fn($query) => $query->where($product_filtering)
                )
                ->max('price'));

            $ranges = collect(Config::get('automotive.filter-ranges.price'));
            self::$data = $ranges
                // Up to max range including one step over current max
                ->filter(fn($range, $i) => $range < $max || ($i > 0 && $range > $max && $ranges[$i - 1] < $max))
                ->filter(fn($range, $i) => $range > $min
                    || ($i < $ranges->count() - 1 && $range < $min && $ranges[$i + 1] > $min));
        }
        return self::$data;
    }
}
