<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AddOn extends Model
{
    protected $table = 'deal_builder_add_ons';

    protected $fillable = [
        'name',
        'description',
        'active',
        'price',
        'allow_roll_into_monthly',
    ];

    public function dealAddOns(): HasMany
    {
        return $this->hasMany(DealAddOn::class, 'add_on_id');
    }

    public function conditions(): HasMany
    {
        return $this->hasMany(AddOnCondition::class);
    }
}
