<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DealFinance extends Model
{
    protected $fillable = [
        'deal_id',
        'provider',
        'type',
        'annual_mileage',
        'first_monthly',
        'monthly_payment',
        'final_payment',
        'full_price',
        'deposit',
        'total_amount',
        'total_credit_amount',
        'apr',
        'interest_rate',
        'number_of_months',
        'cash_price',
        'dealer_deposit',
        'payable_amount',
        'option_to_purchase_fee',
        'documentation_fee',
        'excess_mileage_charge',
        'terms',
        'data',
    ];

    public function deal(): BelongsTo
    {
        return $this->belongsTo(Deal::class, 'deal_id');
    }
}
