<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Customer;
use Mtc\MercuryDataModels\User;

class DealHistory extends Model
{
    protected $table = 'deal_history';

    protected $fillable = [
        'deal_id',
        'status_id',
        'user_id',
        'customer_id',
        'data',
        'notification_sent_at',
    ];

    public function deal(): BelongsTo
    {
        return $this->belongsTo(Deal::class, 'deal_id');
    }

    public function status(): BelongsTo
    {
        return $this->belongsTo(Status::class, 'status_id');
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
}
