<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Customer;
use Mtc\MercuryDataModels\User;

class DealMessage extends Model
{
    protected $fillable = [
        'deal_id',
        'user_id',
        'customer_id',
        'message',
        'data',
        'notification_sent_at',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    protected $touches = [
        'deal',
    ];

    public function deal(): BelongsTo
    {
        return $this->belongsTo(Deal::class, 'deal_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
}
