<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DealPartExchange extends Model
{
    protected $fillable = [
        'deal_id',
        'provider',
        'registration',
        'mileage',
        'vehicle_type',
        'make',
        'model',
        'derivative',
        'fuel_type',
        'engine_size',
        'body_type',
        'transmission',
        'date_of_registration',
        'valuation_made_at',
        'retail_price',
        'average_price',
        'clean_price',
        'below_price',
        'outstanding_finance',
        'cashback_amount',
        'data',
    ];

    public function deal(): BelongsTo
    {
        return $this->belongsTo(Deal::class, 'deal_id');
    }
}
