<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_hits', function (Blueprint $table) {
            $table->id();
            $table->string('endpoint')->index();
            $table->string('status_code')->nullable()->index();
            $table->dateTime('time_window')->nullable()->index();
            $table->unsignedInteger('hits')->default(0)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_hits');
    }
};
