<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->unsignedBigInteger('transmission_id')->index()->nullable();
            $table->unsignedBigInteger('fuel_type_id')->index()->nullable();
            $table->unsignedBigInteger('body_style_id')->index()->nullable();
            $table->unsignedBigInteger('drivetrain_id')->index()->nullable();
            $table->unsignedInteger('engine_size_cc')->nullable()->index();
            $table->string('colour')->nullable()->index();
        });

        Schema::table('vehicle_features', function (Blueprint $table) {
            $table->string('vehicle_type')->index()->nullable()->after('vehicle_id');
            $table->index(['vehicle_type', 'vehicle_id']);
        });

        Schema::table('vehicle_standard_equipment', function (Blueprint $table) {
            $table->string('vehicle_type')->index()->nullable()->after('vehicle_id');
            $table->index(['vehicle_type', 'vehicle_id']);
        });

        Schema::table('vehicle_tech_data', function (Blueprint $table) {
            $table->string('vehicle_type')->index()->nullable()->after('vehicle_id');
            $table->index(['vehicle_type', 'vehicle_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn([
                'transmission_id',
                'fuel_type_id',
                'body_style_id',
                'drivetrain_id',
                'engine_size_cc',
                'colour',
            ]);
        });

        Schema::table('vehicle_features', function (Blueprint $table) {
            $table->dropIndex('vehicle_features_vehicle_type_vehicle_id_index');
            $table->dropColumn('vehicle_type');
        });

        Schema::table('vehicle_standard_equipment', function (Blueprint $table) {
            $table->dropIndex('vehicle_standard_equipment_vehicle_type_vehicle_id_index');
            $table->dropColumn('vehicle_type');
        });

        Schema::table('vehicle_tech_data', function (Blueprint $table) {
            $table->dropIndex('vehicle_tech_data_vehicle_type_vehicle_id_index');
            $table->dropColumn('vehicle_type');
        });
    }
};
